package com.elitesland.cbpl.infinity.client.advice;

import com.elitesland.cbpl.infinity.web.common.vo.InfinityResult;
//import com.elitesland.cbpl.logging.infinity.service.InfinityTrackService;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import static com.elitesland.cbpl.infinity.client.config.InfinityClientProperties.INFINITY_CLIENT_ENABLED;

/**
 * @author eric.hao
 * @since 2023/06/07
 */
@Slf4j
@ControllerAdvice
@Order()
public class InfinityLogAdvice implements ResponseBodyAdvice<InfinityResult<?>> {

//    @Autowired
//    private InfinityTrackService trackService;

    @Override
    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return InfinityResult.class.isAssignableFrom(returnType.getParameterType());
    }

    @Override
    public InfinityResult<?> beforeBodyWrite(InfinityResult<?> body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType,
                                      @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType,
                                      @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (body != null) {
            body.complete(TraceContext.traceId());
        }
        try {
            if (INFINITY_CLIENT_ENABLED) {
                // 记录日志
                //trackService.record(request, response, body);
            } else {
                log.info("[PHOENIX-INFINITY] client disabled.");
            }
        } catch (Exception e) {
            log.error("[PHOENIX-INFINITY] RESPONSE ERR: {}", ExceptionUtils.formatException(e));
        }
        return body;
    }
}
