package com.elitesland.cbpl.infinity.client.router.builder;

import com.elitesland.cbpl.infinity.client.router.builder.impl.RouterParamParse;
import com.elitesland.cbpl.infinity.client.router.service.RouterAuthService;
import com.elitesland.cbpl.infinity.client.router.vo.RouterAuthVO;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.web.common.vo.InfinityResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2021/07/13
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RouterParamBuilder {

    private final RouterAuthService routerAuthService;
    private final RouterParamParse routerParamParse;

    /**
     * 接口参数查询
     */
    public <T, K extends InfinityResponseVO> HttpParam<T, K> routerParamBuilder(InfinityRouterParamVO routerParam, Object requestBody, Class<T> resultType, Class<K> responseType) {
        // 接口相关配置项
        RouterAuthVO routerAuth = routerAuthService.queryRouterAuth(routerParam);
        return UnicomClient.supply(() -> routerParamParse.routerParamBuilder(routerParam, requestBody, resultType, responseType), routerAuth.getParseMethod().name());
    }
}
