package com.elitesland.cbpl.infinity.client.router.builder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.client.router.service.RouterAuthService;
import com.elitesland.cbpl.infinity.client.router.util.InfinityUtil;
import com.elitesland.cbpl.infinity.client.router.vo.RouterAuthVO;
import com.elitesland.cbpl.infinity.server.router.enums.AuthMethod;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.web.common.vo.InfinityResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cbpl.unicom.domain.InvokeTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2021/07/13
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag(InvokeTag.TAG_GENERAL)
public class GeneralParamParse implements RouterParamParse<Object> {

    private final RouterAuthService routerAuthService;

    @Override
    public <T, K extends InfinityResponseVO> HttpParam<T, K> routerParamBuilder(
            InfinityRouterParamVO routerParam, Object requestBody, Class<T> resultType, Class<K> responseType) {
        // 接口相关配置项
        RouterAuthVO routerAuth = routerAuthService.queryRouterAuth(routerParam);
        HttpParam<T, K> params = new HttpParam<>();
        params.setUrl(routerAuth.getUrl());
        params.setRequestMethod(routerAuth.getRequestMethod());

        // 设置鉴权
        if (routerAuth.requiredAuth()) {
            // BASIC
            if (routerAuth.getAuthMethod().equals(AuthMethod.BASIC)) {
                params.setHeaders(InfinityUtil.setBasicAuth(routerAuth));
            }
//            // TODO 定制开发，可扩展：1.token的获取方式不确定；2.token的值要如何传不确定
//            else if (routerAuth.getAuthMethod().equals("TOKEN")) {
//                // requestBody.put("token", getToken());
//            }
            // 不进行鉴权
            else {
                log.trace("[PHOENIX-INFINITY] NoAuth, RouterAuthVO({}).", routerAuth);
            }
        }

        // 设置request、response
        params.setBody(requestBody);
        if (ObjectUtil.isNotEmpty(resultType)) {
            params.setResultType(resultType);
        }
        if (ObjectUtil.isNotEmpty(responseType)) {
            params.setResponseType(responseType);
        }
        return params;
    }
}
