package com.elitesland.cbpl.infinity.client.util;

import com.elitesland.cbpl.infinity.client.convert.SessionConvert;
import com.elitesland.cbpl.infinity.client.domain.InfinityUser;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import org.springframework.util.Assert;

/**
 * 账号上下文信息
 *
 * @author eric.hao
 * @since 2023/06/19
 */
public class InfinitySession {

    private static final ThreadLocal<InfinityUser> CURRENT_ACCOUNT = new ThreadLocal<>();


    private InfinitySession() {
    }

    /**
     * 获取当前账户信息
     *
     * @return 账户信息
     */
    public static InfinityUser getCurrentAccount() {
        return CURRENT_ACCOUNT.get();
    }

    /**
     * 设置当前账户信息
     *
     * @param account 账户信息
     */
    public static void setCurrentAccount(InfinityAccountRespVO account) {
        Assert.notNull(account, "当前账户信息为空");
        CURRENT_ACCOUNT.set(SessionConvert.INSTANCE.toUserVO(account));
    }

    /**
     * 清除当前账户信息
     */
    public static void clearCurrentAccount() {
        CURRENT_ACCOUNT.remove();
    }
}
