/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.account.interceptor;

import com.elitesland.cbpl.infinity.client.router.util.InfinityUtil;
import com.elitesland.cbpl.infinity.client.util.InfinitySession;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.elitesland.cbpl.infinity.web.common.vo.InfinityResult;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private List<InfinityAccountRespVO> accounts;

    public AuthInterceptor(List<InfinityAccountRespVO> accounts) {
        this.accounts = accounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler) throws IOException {
        Optional<InfinityAccountRespVO> matchAccount;
        block7: {
            String token;
            block6: {
                response.addHeader("Content-Type", "application/json");
                response.setCharacterEncoding("UTF-8");
                String requestMethod = request.getMethod();
                token = request.getHeader("Authorization");
                log.info("[PHOENIX-INFINITY] checkApiToken: check token,request method={}, header token={}", (Object)requestMethod, (Object)token);
                if (!StringUtils.isBlank((CharSequence)token)) break block6;
                InfinityResult result = InfinityResult.fail((int)401, (Object)"\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570\uff0c\u8ba4\u8bc1\u5931\u8d25");
                response.getWriter().write(BeanUtils.toJsonStr((Object)result));
                log.error("[PHOENIX-INFINITY] \u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e!");
                boolean bl = false;
                return bl;
            }
            matchAccount = this.accounts.stream().filter(account -> InfinityUtil.checkSignature(token, account.getUsername(), account.getPassword())).findFirst();
            if (!matchAccount.isEmpty()) break block7;
            InfinityResult result = InfinityResult.fail((int)203, (Object)"\u7528\u6237\u540d\u5bc6\u7801\uff0c\u8ba4\u8bc1\u5931\u8d25");
            response.getWriter().write(BeanUtils.toJsonStr((Object)result));
            log.error("[PHOENIX-INFINITY] checkApiToken: authorization invalid, head Authorization={}", (Object)token);
            boolean bl = false;
            return bl;
        }
        try {
            InfinitySession.setCurrentAccount(matchAccount.get());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            InfinityResult result = InfinityResult.fail((int)500, (Object)"\u8ba4\u8bc1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            response.getWriter().write(BeanUtils.toJsonStr((Object)result));
            log.error("[PHOENIX-INFINITY] checkApiToken: catch e.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
    }

    public void postHandle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler, ModelAndView modelAndView) {
        InfinitySession.clearCurrentAccount();
    }

    public void afterCompletion(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler, Exception e) {
    }

    public List<InfinityAccountRespVO> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<InfinityAccountRespVO> accounts) {
        this.accounts = accounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthInterceptor)) {
            return false;
        }
        AuthInterceptor other = (AuthInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<InfinityAccountRespVO> this$accounts = this.getAccounts();
        List<InfinityAccountRespVO> other$accounts = other.getAccounts();
        return !(this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<InfinityAccountRespVO> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        return result;
    }

    public String toString() {
        return "AuthInterceptor(accounts=" + this.getAccounts() + ")";
    }

    public AuthInterceptor() {
    }
}

