/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.advice;

import com.elitesland.cbpl.infinity.client.config.InfinityClientProperties;
import com.elitesland.cbpl.infinity.web.common.vo.InfinityResult;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
@Order
public class InfinityLogAdvice
implements ResponseBodyAdvice<InfinityResult<?>> {
    private static final Logger log = LoggerFactory.getLogger(InfinityLogAdvice.class);

    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return InfinityResult.class.isAssignableFrom(returnType.getParameterType());
    }

    public InfinityResult<?> beforeBodyWrite(InfinityResult<?> body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (body != null) {
            body.complete(TraceContext.traceId());
        }
        try {
            if (!InfinityClientProperties.INFINITY_CLIENT_ENABLED) {
                log.info("[PHOENIX-INFINITY] client disabled.");
            }
        }
        catch (Exception e) {
            log.error("[PHOENIX-INFINITY] RESPONSE ERR: {}", (Object)ExceptionUtils.formatException((Throwable)e));
        }
        return body;
    }
}

