/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.router.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.http.HttpUtil;
import com.elitesland.cbpl.infinity.client.config.InfinityClientProperties;
import com.elitesland.cbpl.infinity.client.router.builder.RouterParamBuilder;
import com.elitesland.cbpl.infinity.client.router.service.RouterClientService;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.web.common.vo.InfinityResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.http.service.InfinityRestClient;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.http.RestWrapper;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class RouterClientServiceImpl
implements RouterClientService {
    private static final Logger log = LoggerFactory.getLogger(RouterClientServiceImpl.class);
    private final RouterParamBuilder routerParamBuilder;
    private final RestWrapper restWrapper;
    private final InfinityRestClient infinityRestClient;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public <T, K extends InfinityResponseVO> List<T> query(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<T> resultType, Class<K> responseType) {
        Assert.isTrue((boolean)InfinityClientProperties.INFINITY_CLIENT_ENABLED, (String)"[PHOENIX-INFINITY] client disabled.", (Object[])new Object[0]);
        HttpParam<T, K> routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, resultType, responseType);
        try {
            InfinityResponseVO response = this.infinityRestClient.exchangeToBean(routerParam);
            if (InfinityResponseVO.success((InfinityResponseVO)response, (String)"S")) {
                List entities = response.getData();
                log.trace("[INFINITY-HTTP] RESULT LIST: {}", (Object)entities);
                return BeanUtils.toList((List)entities, (Class)routerParam.getResultType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.error("[INFINITY-HTTP] QUERY FAIL. URL({}), PARAMS:({})", (Object)routerParam.getUrl(), (Object)BeanUtils.toJsonStr((Object)routerParam.getBody()));
        return Collections.emptyList();
    }

    @Override
    public <K extends InfinityResponseVO> K send(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<K> responseType) {
        return this.sendObj(param, requestBody, responseType);
    }

    @Override
    public <K extends InfinityResponseVO> K send(InfinityRouterParamVO param, List<Map<String, Object>> requestBody, Class<K> responseType) {
        return this.sendObj(param, requestBody, responseType);
    }

    private <K extends InfinityResponseVO> K sendObj(InfinityRouterParamVO param, Object requestBody, Class<K> responseType) {
        Assert.isTrue((boolean)InfinityClientProperties.INFINITY_CLIENT_ENABLED, (String)"[PHOENIX-INFINITY] client disabled.", (Object[])new Object[0]);
        HttpParam routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, null, responseType);
        try {
            return (K)this.infinityRestClient.exchangeToBean(routerParam);
        }
        catch (Exception e) {
            String message = ExceptionUtils.formatException((Throwable)e);
            e.printStackTrace();
            log.error("[INFINITY-HTTP] PUT FAIL. URL({}), PARAMS:({})", (Object)routerParam.getUrl(), (Object)BeanUtils.toJsonStr((Object)routerParam.getBody()));
            InfinityResponseVO error = InfinityResponseVO.error((String)message);
            return (K)((InfinityResponseVO)BeanUtils.toBean((String)BeanUtils.toJsonStr((Object)error), responseType));
        }
    }

    @Override
    public String exchange(InfinityRouterParamVO param, Map<String, Object> requestBody) {
        Assert.isTrue((boolean)InfinityClientProperties.INFINITY_CLIENT_ENABLED, (String)"[PHOENIX-INFINITY] client disabled.", (Object[])new Object[0]);
        HttpParam routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, null, null);
        try {
            return this.infinityRestClient.exchange(routerParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("[INFINITY-HTTP] PUT FAIL. URL({}), PARAMS:({})", (Object)routerParam.getUrl(), (Object)BeanUtils.toJsonStr((Object)routerParam.getBody()));
            return "";
        }
    }

    @Override
    public Resource exchangeStream(InfinityRouterParamVO param, Map<String, Object> requestBody) {
        Assert.isTrue((boolean)InfinityClientProperties.INFINITY_CLIENT_ENABLED, (String)"[PHOENIX-INFINITY] client disabled.", (Object[])new Object[0]);
        HttpParam routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, null, null);
        try {
            String queryParams = HttpUtil.toParams((Map)routerParam.getBodyMap(), (Charset)StandardCharsets.UTF_8);
            String requestUrl = routerParam.getUrl() + "?" + queryParams;
            HttpEntity entity = this.restWrapper.getMethodHttpEntity(routerParam.getHeaders());
            return (Resource)this.restTemplate.exchange(URI.create(requestUrl), HttpMethod.GET, entity, Resource.class).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("[INFINITY-HTTP] PUT FAIL. URL({}), PARAMS:({})", (Object)routerParam.getUrl(), (Object)BeanUtils.toJsonStr((Object)routerParam.getBody()));
            return null;
        }
    }

    public RouterClientServiceImpl(RouterParamBuilder routerParamBuilder, RestWrapper restWrapper, InfinityRestClient infinityRestClient) {
        this.routerParamBuilder = routerParamBuilder;
        this.restWrapper = restWrapper;
        this.infinityRestClient = infinityRestClient;
    }
}

