/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.db.config;

import com.elitesland.cbpl.infinity.db.config.InfinityDbProperties;
import com.elitesland.cbpl.infinity.db.source.loader.DataSourceLoader;
import com.elitesland.cbpl.infinity.db.source.service.DataSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={InfinityDbProperties.class})
@ConditionalOnProperty(prefix="cbpl.infinity.db", name={"enabled"}, havingValue="true")
public class InfinityDbConfig {
    private static final Logger log = LoggerFactory.getLogger(InfinityDbConfig.class);

    @Bean
    @ConditionalOnBean(value={DataSourceLoader.class})
    public DataSourceService dataSourceService(DataSourceLoader dataSourceLoader) {
        return new DataSourceService(dataSourceLoader);
    }
}

