/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.db.provider;

import com.elitesland.cbpl.infinity.db.provider.InfinityDbReader;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class AbstractDbReader
implements InfinityDbReader {
    private static final Logger log = LoggerFactory.getLogger(AbstractDbReader.class);

    protected abstract NamedParameterJdbcTemplate jdbcTemplate();

    @Override
    public long countRows(String sql) {
        long count = (Long)this.jdbcTemplate().queryForObject(sql, (SqlParameterSource)null, Long.class);
        return Math.min(count, 1L);
    }

    protected abstract String toPagingSql(String var1, long var2, long var4);

    @Override
    public List<Map<String, Object>> readTable(String sql, long limit, long offset) {
        return this.jdbcTemplate().query(this.toPagingSql(sql, limit, offset), (RowMapper)new ColumnMapRowMapper());
    }

    public <T> List<T> query(String sql, Map<String, ?> paramMap, Class<T> clazz) {
        return this.jdbcTemplate().query(sql, paramMap, (RowMapper)new BeanPropertyRowMapper(clazz));
    }

    public List<Map<String, Object>> queryForList(String sql) {
        return this.jdbcTemplate().queryForList(sql, (SqlParameterSource)((BeanPropertySqlParameterSource)null));
    }

    public List<Map<String, Object>> queryForList(String sql, Map<String, Object> paramMap) {
        return this.jdbcTemplate().queryForList(sql, paramMap);
    }

    public <T> List<T> queryToObject(String sql, Map<String, Object> paramMap, Class<T> cls) {
        return this.jdbcTemplate().queryForList(sql, paramMap, cls);
    }
}

