/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.db.provider;

import com.elitesland.cbpl.infinity.db.provider.InfinityDbWriter;
import com.elitesland.cbpl.infinity.db.util.JdbcUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class AbstractDbWriter
implements InfinityDbWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDbWriter.class);

    protected abstract String jdbcTemplateType();

    protected abstract NamedParameterJdbcTemplate jdbcTemplate();

    @Override
    public long writeTable(String tableName, List<Map<String, Object>> rows, boolean append) {
        if (!append) {
            this.jdbcTemplate().update(this.buildClearSql(tableName), (SqlParameterSource)null);
            log.info("[INFINITY-DB][AbstractDbWriter] 1. {} ({}) \u5df2\u6e05\u9664.", (Object)tableName, (Object)this.jdbcTemplateType());
        }
        if (rows.isEmpty()) {
            log.info("[INFINITY-DB][AbstractDbWriter] 2. \u540c\u6b65\u6e90\u6ca1\u6709\u6570\u636e.");
            return 0L;
        }
        String sql = JdbcUtil.buildInsertSql(tableName, rows.get(0).keySet());
        int[] results = this.jdbcTemplate().batchUpdate(sql, rows.toArray(new Map[0]));
        log.info("[INFINITY-DB][AbstractDbWriter] 3. {} ({}) \u5df2\u6e05\u9664.", (Object)tableName, (Object)results);
        return JdbcUtil.countResults(results);
    }

    public String buildClearSql(String tableName) {
        return "delete from " + tableName;
    }

    public void deleteTableById(String tableName, String sqlStr) {
        String s = this.buildClearSql(tableName + " where " + sqlStr);
        int update = this.jdbcTemplate().update(this.buildClearSql(tableName + " where " + sqlStr), (SqlParameterSource)null);
        log.info("[INFINITY-DB][AbstractDbWriter] {} ({}) \u5df2\u6e05\u9664.", (Object)tableName, (Object)update);
    }

    public int update(String sql, Map<String, Object> line) {
        return this.jdbcTemplate().update(sql, (SqlParameterSource)new MapSqlParameterSource(line));
    }
}

