/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.db.source.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.db.source.loader.DataSourceLoader;
import com.elitesland.cbpl.infinity.db.source.loader.DefaultSettingLoader;
import com.elitesland.cbpl.infinity.db.source.provider.DataSourceProvider;
import com.elitesland.cbpl.infinity.db.source.vo.DataSourceVO;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceService.class);
    private final DataSourceLoader dataSourceLoader;
    private final Map<String, DataSourceProvider> providers = new HashMap<String, DataSourceProvider>();

    @PostConstruct
    public void init() {
        List<DataSourceVO> ds = this.dataSourceLoader.loadDataSource();
        if (CollUtil.isEmpty(ds)) {
            log.info("[PHOENIX-INFINITY] load datasource empty.");
            return;
        }
        ds.forEach(this::createDataSource);
    }

    private void createDataSource(DataSourceVO ds) {
        Properties properties = ObjectUtil.isEmpty((Object)ds.getProperties()) ? DefaultSettingLoader.getProperties(ds.getName()) : ds.getProperties();
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(ds.getUrl());
        dataSource.setUsername(ds.getUsername());
        dataSource.setPassword(ds.getPassword());
        dataSource.setDriverClassName(ds.getDriverClassName());
        dataSource.setDataSourceProperties(properties);
        this.providers.put(ds.getName(), DataSourceProvider.setDatasource((DataSource)dataSource));
    }

    public NamedParameterJdbcTemplate getJdbcTemplate(String name) {
        DataSourceProvider provider = this.providers.get(name);
        if (ObjectUtil.isNull((Object)provider)) {
            throw new RuntimeException("\u8bfb\u53d6\u5931\u8d25\uff0c\u672a\u627e\u5230\u6570\u636e\u6e90");
        }
        if (!provider.isInitialized()) {
            throw new RuntimeException("\u8bfb\u53d6\u5931\u8d25\uff0c\u6570\u636e\u6e90\u672a\u521d\u59cb\u5316");
        }
        return provider.getJdbcTemplate();
    }

    public DataSourceService(DataSourceLoader dataSourceLoader) {
        this.dataSourceLoader = dataSourceLoader;
    }
}

