/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.db.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class JdbcUtil {
    public static Predicate<String> excludeHelperName = columnName -> !columnName.endsWith("__");

    public static SqlParameterSource[] toParamSources(List<Map<String, Object>> rows) {
        return (SqlParameterSource[])rows.stream().map(MapSqlParameterSource::new).toArray(SqlParameterSource[]::new);
    }

    public static String buildInsertSql(String tableName, Set<String> columnNames) {
        StringBuilder sb = new StringBuilder("insert into ");
        sb.append(tableName).append(" (");
        sb.append(columnNames.stream().filter(excludeHelperName).collect(Collectors.joining(", ")));
        sb.append(") values (:");
        sb.append(columnNames.stream().filter(excludeHelperName).collect(Collectors.joining(", :")));
        sb.append(")");
        return sb.toString();
    }

    public static long countResults(int[] results) {
        long count = 0L;
        for (int result : results) {
            count += (long)result;
        }
        return count;
    }
}

