package com.elitesland.cbpl.infinity.db.config;

import com.elitesland.cbpl.infinity.db.source.loader.DataSourceLoader;
import com.elitesland.cbpl.infinity.db.source.service.DataSourceService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.infinity.db.config.InfinityDbProperties.INFINITY_DB_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/12/21
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(InfinityDbProperties.class)
@ConditionalOnProperty(prefix = INFINITY_DB_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class InfinityDbConfig {

    @Bean
    @ConditionalOnBean(DataSourceLoader.class)
    public DataSourceService dataSourceService(DataSourceLoader dataSourceLoader){
        return new DataSourceService(dataSourceLoader);
    }
}
