package com.elitesland.cbpl.infinity.db.config;

import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author eric.hao
 * @since 2023/12/21
 */
@Data
@ConfigurationProperties(prefix = InfinityDbProperties.INFINITY_DB_CONFIG_PREFIX)
public class InfinityDbProperties implements InitializingBean {

    public static final String INFINITY_DB_CONFIG_PREFIX = "cbpl.infinity.db";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;


    public static boolean INFINITY_DB_ENABLED;

    @Override
    public void afterPropertiesSet() throws Exception {
        INFINITY_DB_ENABLED = enabled;
    }
}
