package com.elitesland.cbpl.infinity.db.log.domain;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/10/17
 */
@Data
@AllArgsConstructor(staticName = "of")
public class SyncCallPayload {

    /**
     * 实例ID
     */
    private Long instanceId;

    /**
     * 接口类型
     */
    private String intfType;

    /**
     * 返回信息
     */
    private String intfMsg;

    public Map<String, Object> source() {
        var param = new HashMap<String, Object>();
        param.put("INSTANCE_ID", instanceId);
        param.put("INTF_TYPE", intfType);
        param.put("INTF_MSG", intfMsg);
        return param;
    }
}
