//package com.elitesland.cbpl.infinity.db.log.service;
//
//
//import com.elitesland.cbpl.infinity.db.log.domain.SyncCallPayload;
//import com.elitesland.cbpl.infinity.db.log.domain.SyncLogPayload;
//
//import java.time.LocalDateTime;
//
///**
// * @author eric.hao
// * @since 2023/10/17
// */
//public interface SyncLogService {
//
//    /**
//     * 接口调用记录
//     */
//    void syncCall(SyncCallPayload payload);
//
//    /**
//     * 接口执行日志
//     */
//    void syncLog(SyncLogPayload payload);
//
//    /**
//     * 更新执行时间
//     *
//     * @param intfType    任务类型
//     * @param executeTime 执行时间
//     */
//    void updateLastTime(String intfType, LocalDateTime executeTime);
//
//    /**
//     * 查询上次执行时间
//     *
//     * @param intfType 任务类型
//     * @return 上次执行时间
//     */
//    LocalDateTime queryLastTime(String intfType);
//
//    /**
//     * 查询上次执行时间，并减一分钟
//     *
//     * @param intfType 任务类型
//     * @return 上次执行时间 - 1min
//     */
//    default String queryLastTimeBeforeMinutes(String intfType) {
//        return queryLastTimeBeforeMinutes(intfType, 1L);
//    }
//
//    /**
//     * 查询上次执行时间，并减 n 分钟
//     *
//     * @param intfType 任务类型
//     * @param minutes  减去的分钟数
//     * @return 计算后的执行时间
//     */
//    String queryLastTimeBeforeMinutes(String intfType, long minutes);
//}
