//package com.elitesland.cbpl.infinity.db.log.service;
//
//import cn.hutool.core.date.DateUtil;
//import com.elitesland.cbpl.infinity.db.log.domain.SyncCallPayload;
//import com.elitesland.cbpl.infinity.db.log.domain.SyncLogPayload;
//import com.elitesland.cbpl.infinity.db.log.domain.SyncTime;
//import lombok.RequiredArgsConstructor;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Propagation;
//import org.springframework.transaction.annotation.Transactional;
//
//import java.time.LocalDateTime;
//import java.util.HashMap;
//import java.util.Map;
//
///**
// * @author eric.hao
// * @since 2023/10/17
// */
//@Slf4j
//@Service
//@RequiredArgsConstructor
//public class SyncLogServiceImpl implements SyncLogService {
//
//    private final SorDbReader sorDbReader;
//    private final SorDbWriter sorDbWriter;
//
//    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
//    @Override
//    public void syncCall(SyncCallPayload payload) {
//        log.debug("[SYNC-CALL] payload-{}", payload);
//        var insertSql = "INSERT INTO INTF_CALL_LOG (INSTANCE_ID, INTF_TYPE, INTF_MSG, DT) VALUES (:INSTANCE_ID, :INTF_TYPE, :INTF_MSG, NOW())";
//        sorDbWriter.update(insertSql, payload.source());
//    }
//
//    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
//    @Override
//    public void syncLog(SyncLogPayload payload) {
//        log.debug("[SYNC-LOG] payload-{}", payload);
//        var insertSql = "INSERT INTO INTF_LOG (" +
//                "   INTF_TYPE, RUN_TYPE, INTF_MSG, DT, DOC_ID, DOC_NO" +
//                ") VALUES (" +
//                "   :INTF_TYPE, :RUN_TYPE, :INTF_MSG, sysdate(), :DOC_ID, :DOC_NO" +
//                ")";
//        sorDbWriter.update(insertSql, payload.source());
//    }
//
//    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
//    @Override
//    public void updateLastTime(String intfType, LocalDateTime executeTime) {
//        log.debug("[SYNC-LOG] update {} lastTime.", intfType);
//        Map<String, Object> param = new HashMap<>();
//        param.put("INTF_TYPE", intfType);
//        param.put("EXECUTE_TIME", executeTime);
//        var updateSql = "UPDATE INTF_LASTTIME SET LAST_RUN_TIME = :EXECUTE_TIME WHERE INTF_TYPE = :INTF_TYPE";
//        int updateCount = sorDbWriter.update(updateSql, param);
//        if (updateCount == 0) {
//            var insertSql = "INSERT INTO INTF_LASTTIME(INTF_TYPE, LAST_RUN_TIME) VALUES (:INTF_TYPE, :EXECUTE_TIME)";
//            sorDbWriter.update(insertSql, param);
//        }
//    }
//
//    @Override
//    public LocalDateTime queryLastTime(String intfType) {
//        log.debug("[SYNC-LOG] query {} lastTime.", intfType);
//        Map<String, Object> param = new HashMap<>();
//        param.put("INTF_TYPE", intfType);
//        var querySql = "SELECT LAST_RUN_TIME syncTime FROM INTF_LASTTIME WHERE INTF_TYPE = :INTF_TYPE";
//        var lastTimes = sorDbReader.query(querySql, param, SyncTime.class);
//        return lastTimes.isEmpty() ? LocalDateTime.now() : lastTimes.get(0).getSyncTime();
//    }
//
//    @Override
//    public String queryLastTimeBeforeMinutes(String intfType, long minutes) {
//        var lastTime = queryLastTime(intfType);
//        return DateUtil.formatLocalDateTime(lastTime.minusMinutes(minutes));
//    }
//}
