package com.elitesland.cbpl.infinity.db.provider;

import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/10/17
 */
public interface InfinityDbReader {

    /**
     * 获取指定数据表的数据行数
     *
     * @param tableName 表名
     * @return 数据行数
     */
    long countRows(String tableName);

    /**
     * 读取数据
     *
     * @param tableName 表名
     * @param limit     读取多少行
     * @param offset    从那一行开始(索引从 0 开始)
     * @return 数据集
     */
    List<Map<String, Object>> readTable(String tableName, long limit, long offset);
}
