package com.elitesland.cbpl.infinity.db.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.infinity.db.source.loader.DataSourceLoader;
import com.elitesland.cbpl.infinity.db.source.service.DataSourceService;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import static com.elitesland.cbpl.infinity.db.config.InfinityDbProperties.INFINITY_DB_ENABLED;
import static com.elitesland.cbpl.tool.extra.spring.SpringUtils.isPresent;

/**
 * @author eric.hao
 * @since 2023/12/21
 */
public class DsUtil {

    private static DataSourceService dataSourceService;

    private static DataSourceService getInstance() {
        Assert.isTrue(INFINITY_DB_ENABLED, "Infinity DB tool not enabled.");
        Assert.isTrue(isPresent(DataSourceLoader.class), "DataSourceLoader not found implements.");

        if (dataSourceService == null) {
            dataSourceService = SpringUtil.getBean(DataSourceService.class);
        }
        return dataSourceService;
    }

    /**
     * 读取指定名称的数据源
     *
     * @param name 数据源名称
     * @return jdbcTemplate
     */
    public static NamedParameterJdbcTemplate getJdbcTemplate(String name) {
        return getInstance().getJdbcTemplate(name);
    }
}
