package com.elitesland.cbpl.infinity.db.source.provider;

import cn.hutool.core.lang.Assert;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import javax.sql.DataSource;

/**
 * @author eric.hao
 * @since 2023/10/17
 */
public class DataSourceProvider {

    /**
     * 是否已初始化成功
     */
    private boolean initialized;

    private NamedParameterJdbcTemplate jdbcTemplate;

    /**
     * 是否已初始化可用
     *
     * @return 是否已初始化可用
     */
    public boolean isInitialized() {
        return initialized;
    }

    /**
     * jdbcTemplate
     *
     * @return jdbcTemplate
     */
    public NamedParameterJdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    /**
     * 设置数据源
     *
     * @param dataSource 数据源
     */
    public static DataSourceProvider setDatasource(DataSource dataSource) {
        Assert.notNull(dataSource, "数据源为空");
        DataSourceProvider ds = new DataSourceProvider();
        ds.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        ds.initialized = true;
        return ds;
    }
}
