package com.elitesland.cbpl.infinity.db.util;

import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2023/10/17
 */
public abstract class JdbcUtil {

    /**
     * @param rows 数据集
     * @return 参数集
     */
    public static SqlParameterSource[] toParamSources(List<Map<String, Object>> rows) {
        return rows.stream()
                .map(MapSqlParameterSource::new)
                .toArray(SqlParameterSource[]::new);
    }

    /**
     * 排除辅助列(比如，Oracle处理中的`rn__`)
     */
    public static Predicate<String> excludeHelperName = columnName -> !columnName.endsWith("__");

    /**
     * @param tableName   数据表名
     * @param columnNames 字段名集
     * @return INSERT语句
     */
    public static String buildInsertSql(String tableName, Set<String> columnNames) {
        StringBuilder sb = new StringBuilder("insert into ");
        sb.append(tableName).append(" (");
        sb.append(columnNames.stream().filter(excludeHelperName)
                .collect(Collectors.joining(", ")));
        sb.append(") values (:");
        sb.append(columnNames.stream().filter(excludeHelperName)
                .collect(Collectors.joining(", :")));
        sb.append(")");
        return sb.toString();
    }

    /**
     * @param results 更新结果
     * @return 更新数
     */
    public static long countResults(int[] results) {
        long count = 0;
        for (int result : results) {
            count += result;
        }
        return count;
    }
}
