package com.elitesland.cbpl.infinity.db.log.domain;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/10/17
 */
@Data
@AllArgsConstructor(staticName = "of")
public class SyncLogPayload {

    /**
     * 接口类型
     */
    private String intfType;

    /**
     * 运行类型
     */
    private String runType;

    /**
     * 返回信息
     */
    private String intfMsg;

    /**
     * 单据ID
     */
    private String docId;

    /**
     * 单据编号
     */
    private String docNo;

    public Map<String, Object> source() {
        var param = new HashMap<String, Object>();
        param.put("INTF_TYPE", intfType);
        param.put("RUN_TYPE", runType);
        param.put("INTF_MSG", intfMsg);
        param.put("DOC_ID", docId);
        param.put("DOC_NO", docNo);
        return param;
    }
}
