package com.elitesland.cbpl.infinity.server.account.repo;

import com.elitesland.cbpl.infinity.server.account.entity.InfinityAccountDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Repository
public interface InfinityAccountRepo extends JpaRepository<InfinityAccountDO, Long>, QuerydslPredicateExecutor<InfinityAccountDO> {

    /**
     * 根据用户名 查询认证账号
     *
     * @param username 用户名
     * @return 认证账号
     */
    List<InfinityAccountDO> findByUsername(String username);
}
