package com.elitesland.cbpl.infinity.server.account.service;

import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
public interface InfinityAccountService {

    /**
     * 查找认证账号
     *
     * @param username 用户名
     * @return 账号列表
     */
    List<InfinityAccountRespVO> queryAccounts(String username);

    /**
     * 需要唯一且可用的认证账号
     *
     * @param username 用户名
     * @return 认证账号
     */
    InfinityAccountRespVO queryOneAccount(String username);
}
