package com.elitesland.cbpl.infinity.server.audit.service;

import com.elitesland.cbpl.infinity.server.audit.vo.resp.InfinityAuditRespVO;

/**
 * @author eric.hao
 * @since 2021/07/13
 */
public interface InfinityAuditService {

    /**
     * 接口最后执行时间
     *
     * @param routerCode 接口编码
     * @return 最后执行时间
     */
    InfinityAuditRespVO getLastTime(String routerCode);

    /**
     * 查询接口最后更新时间
     *
     * @param routerCode
     * @return
     */
    String getLastTimeStr(String routerCode, String defaultTime);

    /**
     * 更新最后执行时间
     *
     * @param routerCode 接口编码
     * @param nowTime       当前时间
     */
    long updateLastTime(String routerCode, String nowTime);
}
