package com.elitesland.cbpl.infinity.server.audit.service;

import com.elitesland.cbpl.infinity.server.audit.entity.InfinityAuditDO;
import com.elitesland.cbpl.infinity.server.audit.repo.InfinityAuditRepo;
import com.elitesland.cbpl.infinity.server.audit.repo.InfinityAuditRepoProc;
import com.elitesland.cbpl.infinity.server.audit.vo.resp.InfinityAuditRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import static com.elitesland.cbpl.infinity.server.audit.vo.resp.InfinityAuditRespVO.LAST_UPDATE_DATE;
import static com.elitesland.cbpl.infinity.server.audit.vo.resp.InfinityAuditRespVO.LAST_UPDATE_TIME;

/**
 * @author eric.hao
 * @since 2021/07/13
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityAuditServiceImpl implements InfinityAuditService {

    private final InfinityAuditRepo infinityAuditRepo;
    private final InfinityAuditRepoProc infinityAuditRepoProc;

    @Override
    public InfinityAuditRespVO getLastTime(String routerCode) {
        InfinityAuditDO task = infinityAuditRepo.findByRouterCode(routerCode);
        if (task == null) {
            InfinityAuditDO historyDO = new InfinityAuditDO();
            historyDO.setRouterCode(routerCode);
            historyDO.setLastUpdateTime(LAST_UPDATE_DATE + LAST_UPDATE_TIME);
            infinityAuditRepo.save(historyDO);
            return InfinityAuditRespVO.initTime(routerCode);
        }
        String bdate = task.getLastUpdateTime().substring(0, 8);
        String btime = task.getLastUpdateTime().substring(8);
        return InfinityAuditRespVO.of(routerCode, bdate, btime);
    }

    @Override
    public String getLastTimeStr(String routerCode, String defaultTime) {
        InfinityAuditDO history = infinityAuditRepo.findByRouterCode(routerCode);
        if (history == null) {
            InfinityAuditDO historyDO = new InfinityAuditDO();
            historyDO.setRouterCode(routerCode);
            historyDO.setLastUpdateTime(defaultTime);
            infinityAuditRepo.save(historyDO);
            return defaultTime;
        }
        return history.getLastUpdateTime();
    }

    @Transactional
    @Override
    public long updateLastTime(String routerCode, String nowTime) {
        return infinityAuditRepoProc.updateLastTime(routerCode, nowTime);
    }
}
