package com.elitesland.cbpl.infinity.server.platform.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2021/07/14
 */
@Entity
@Table(name = "infinity_platform")
@org.hibernate.annotations.Table(appliesTo = "infinity_platform", comment = "平台认证用户、密码、appKey、appSecret等")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class InfinityPlatformDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 165434781132588149L;

    @Column()
    @Comment("组织编码")
    private String buCode;

    @Column()
    @Comment("平台编码：ERP、饿了么、旺店通等")
    private String platformCode;

    @Column()
    @Comment("平台账号")
    private String username;

    @Column()
    @Comment("平台密码")
    private String password;

    @Column()
    @Comment("登录用户名")
    private String loginName;

    @Column()
    @Comment("平台应用ID")
    private String appId;

    @Column()
    @Comment("AppKey")
    private String appKey;

    @Column()
    @Comment("AppSecret")
    private String appSecret;
}
