package com.elitesland.cbpl.infinity.server.platform.service;

import com.elitesland.cbpl.infinity.server.platform.vo.resp.InfinityPlatformRespVO;
import com.elitesland.cbpl.infinity.server.router.convert.RouterConvert;
import com.elitesland.cbpl.infinity.server.platform.vo.param.InfinityPlatformParamVO;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.server.platform.repo.InfinityPlatformRepo;
import com.elitesland.cbpl.infinity.server.platform.repo.InfinityPlatformRepoProc;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityPlatformServiceImpl implements InfinityPlatformService {

    private final InfinityPlatformRepo platformRepo;
    private final InfinityPlatformRepoProc platformRepoProc;

    @Override
    public List<InfinityPlatformRespVO> queryAuths(InfinityPlatformParamVO param) {
        List<InfinityPlatformRespVO> auths = platformRepoProc.queryAuth(param);
        if (auths.isEmpty()) {
            throw PhoenixException.unchecked("[INFINITY-PLATFORM] auth account not exist: " + param);
        }
        return auths;
    }

    @Override
    public InfinityPlatformRespVO queryOneAuth(InfinityRouterParamVO param) {
        List<InfinityPlatformRespVO> auths = queryAuths(RouterConvert.INSTANCE.httpToAuthParam(param));
        if (auths.size() > 1) {
            throw PhoenixException.unchecked("[INFINITY-PLATFORM] auth account not unique: " + param.toString());
        }
        return auths.get(0);
    }
}
