/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.account.service;

import com.elitesland.cbpl.infinity.server.account.repo.InfinityAccountRepo;
import com.elitesland.cbpl.infinity.server.account.repo.InfinityAccountRepoProc;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InfinityAccountServiceImpl
implements InfinityAccountService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityAccountServiceImpl.class);
    private final InfinityAccountRepo infinityAccountRepo;
    private final InfinityAccountRepoProc infinityAccountRepoProc;

    @Override
    public List<InfinityAccountRespVO> queryAccounts(String username) {
        return this.infinityAccountRepoProc.queryAccounts(username);
    }

    @Override
    public InfinityAccountRespVO queryOneAccount(String username) {
        List<InfinityAccountRespVO> accounts = this.queryAccounts(username);
        if (accounts.size() > 1) {
            throw PhoenixException.unchecked((String)("[INFINITY-ACCOUNT] account not unique: " + username));
        }
        return accounts.get(0);
    }

    public InfinityAccountServiceImpl(InfinityAccountRepo infinityAccountRepo, InfinityAccountRepoProc infinityAccountRepoProc) {
        this.infinityAccountRepo = infinityAccountRepo;
        this.infinityAccountRepoProc = infinityAccountRepoProc;
    }
}

