/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.audit.service;

import com.elitesland.cbpl.infinity.server.audit.entity.InfinityAuditDO;
import com.elitesland.cbpl.infinity.server.audit.repo.InfinityAuditRepo;
import com.elitesland.cbpl.infinity.server.audit.repo.InfinityAuditRepoProc;
import com.elitesland.cbpl.infinity.server.audit.service.InfinityAuditService;
import com.elitesland.cbpl.infinity.server.audit.vo.resp.InfinityAuditRespVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InfinityAuditServiceImpl
implements InfinityAuditService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityAuditServiceImpl.class);
    private final InfinityAuditRepo infinityAuditRepo;
    private final InfinityAuditRepoProc infinityAuditRepoProc;

    @Override
    public InfinityAuditRespVO getLastTime(String routerCode) {
        InfinityAuditDO task = this.infinityAuditRepo.findByRouterCode(routerCode);
        if (task == null) {
            InfinityAuditDO historyDO = new InfinityAuditDO();
            historyDO.setRouterCode(routerCode);
            historyDO.setLastUpdateTime("20210101000000");
            this.infinityAuditRepo.save(historyDO);
            return InfinityAuditRespVO.initTime(routerCode);
        }
        String bdate = task.getLastUpdateTime().substring(0, 8);
        String btime = task.getLastUpdateTime().substring(8);
        return InfinityAuditRespVO.of(routerCode, bdate, btime);
    }

    @Override
    public String getLastTimeStr(String routerCode, String defaultTime) {
        InfinityAuditDO history = this.infinityAuditRepo.findByRouterCode(routerCode);
        if (history == null) {
            InfinityAuditDO historyDO = new InfinityAuditDO();
            historyDO.setRouterCode(routerCode);
            historyDO.setLastUpdateTime(defaultTime);
            this.infinityAuditRepo.save(historyDO);
            return defaultTime;
        }
        return history.getLastUpdateTime();
    }

    @Override
    @Transactional
    public long updateLastTime(String routerCode, String nowTime) {
        return this.infinityAuditRepoProc.updateLastTime(routerCode, nowTime);
    }

    public InfinityAuditServiceImpl(InfinityAuditRepo infinityAuditRepo, InfinityAuditRepoProc infinityAuditRepoProc) {
        this.infinityAuditRepo = infinityAuditRepo;
        this.infinityAuditRepoProc = infinityAuditRepoProc;
    }
}

