package com.elitesland.cbpl.infinity.server.audit.repo;

import com.elitesland.cbpl.infinity.server.audit.entity.QInfinityAuditDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

/**
 * @author eric.hao
 * @since 2021/07/14
 */
@Repository
@RequiredArgsConstructor
public class InfinityAuditRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QInfinityAuditDO Q_INFINITY_AUDIT_DO = QInfinityAuditDO.infinityAuditDO;

    public long updateLastTime(String routerCode, String lastUpdateTime) {
        return jpaQueryFactory
                .update(Q_INFINITY_AUDIT_DO)
                .set(Q_INFINITY_AUDIT_DO.lastUpdateTime, lastUpdateTime)
                .where(Q_INFINITY_AUDIT_DO.routerCode.eq(routerCode))
                .execute();
    }
}
