package com.elitesland.cbpl.infinity.server.audit.vo.resp;

import lombok.Data;

import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2021/07/14
 */
@Data
public class InfinityAuditRespVO implements Serializable {

    private static final long serialVersionUID = 6127009229553480001L;

    /**
     * 接口编码
     */
    private String routerCode;

    /**
     * 最后执行日期(yyyyMMdd)
     */
    private String lastUpdateDate;

    /**
     * 最后执行时间(HHmmss)
     */
    private String lastUpdateTime;

    public static InfinityAuditRespVO of(String routerCode, String lastUpdateDate, String lastUpdateTime) {
        InfinityAuditRespVO task = new InfinityAuditRespVO();
        task.setRouterCode(routerCode);
        task.setLastUpdateDate(lastUpdateDate);
        task.setLastUpdateTime(lastUpdateTime);
        return task;
    }

    public static final String LAST_UPDATE_DATE = "20210101";
    public static final String LAST_UPDATE_TIME = "000000";

    public static InfinityAuditRespVO initTime(String routerCode) {
        return InfinityAuditRespVO.of(routerCode, LAST_UPDATE_DATE, LAST_UPDATE_TIME);
    }

    public String getLastTime() {
        return lastUpdateDate + lastUpdateTime;
    }
}
