package com.elitesland.cbpl.infinity.server.router.vo.param;

import lombok.Builder;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Data
@Builder
public class InfinityRouterParamVO {

    /**
     * 认证ID
     */
    private Long authId;

    /**
     * 平台编码
     */
    private String platformCode;

    /**
     * 组织编码
     */
    private String buCode;

    /**
     * 接口编码
     */
    private String routerCode;

    /**
     * 接口参数
     *
     * @param platformCode 平台编码
     * @param routerCode   接口编码
     * @param buCode       组织编码
     */
    public static InfinityRouterParamVO of(String platformCode, String routerCode, String buCode) {
        return InfinityRouterParamVO.builder()
                .platformCode(platformCode).routerCode(routerCode).buCode(buCode)
                .build();
    }
}
