CREATE TABLE `infinity_account` (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `belong_tenant` bigint DEFAULT NULL COMMENT '所属租户',
    `username` varchar(255) DEFAULT NULL COMMENT '认证账号',
    `password` varchar(255) DEFAULT NULL COMMENT '认证密码',
    `intercept_uri` varchar(255) DEFAULT NULL COMMENT '拦截地址：逗号分隔',
    `platform_code` varchar(255) DEFAULT NULL COMMENT '平台编码：WMS、BOH、美团、旺店通等',
    `tags` varchar(255) DEFAULT NULL COMMENT '自定义标签',
    `tenant_id` bigint DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id` bigint DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id` bigint DEFAULT NULL COMMENT '租户组织ID',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id` bigint DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id` bigint DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id` bigint DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB COMMENT='对外提供接口的认证账号';

CREATE TABLE `infinity_audit` (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `bu_code` varchar(255) DEFAULT NULL COMMENT '组织编码',
    `platform_code` varchar(255) DEFAULT NULL COMMENT '平台编码：ERP、饿了么、旺店通等',
    `router_code` varchar(255) DEFAULT NULL COMMENT '接口编码',
    `last_update_time` varchar(255) DEFAULT NULL COMMENT '最后更新时间',
    `tenant_id` bigint DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id` bigint DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id` bigint DEFAULT NULL COMMENT '租户组织ID',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id` bigint DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id` bigint DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id` bigint DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB COMMENT='接口同步审计表';

CREATE TABLE `infinity_platform` (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `bu_code` varchar(255) DEFAULT NULL COMMENT '组织编码',
    `platform_code` varchar(255) DEFAULT NULL COMMENT '平台编码：ERP、饿了么、旺店通等',
    `username` varchar(255) DEFAULT NULL COMMENT '平台账号',
    `password` varchar(255) DEFAULT NULL COMMENT '平台密码',
    `login_name` varchar(255) DEFAULT NULL COMMENT '登录用户名',
    `app_id` varchar(255) DEFAULT NULL COMMENT '平台应用ID',
    `app_key` varchar(255) DEFAULT NULL COMMENT 'AppKey',
    `app_secret` varchar(255) DEFAULT NULL COMMENT 'AppSecret',
    `tenant_id` bigint DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id` bigint DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id` bigint DEFAULT NULL COMMENT '租户组织ID',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id` bigint DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id` bigint DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id` bigint DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB COMMENT='平台认证用户、密码、appKey、appSecret等';

CREATE TABLE `infinity_router` (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `auth_id` bigint DEFAULT NULL COMMENT '认证表ID',
    `group_id` bigint DEFAULT NULL COMMENT '分组ID',
    `router_code` varchar(255) DEFAULT NULL COMMENT '接口编码',
    `router_name` varchar(255) DEFAULT NULL COMMENT '接口名称',
    `request_method` varchar(255) DEFAULT NULL COMMENT '请求方式',
    `url` varchar(255) DEFAULT NULL COMMENT '接口地址',
    `action` varchar(255) DEFAULT NULL COMMENT '接口动作：用于标识接口用途',
    `parse_method` varchar(255) DEFAULT NULL COMMENT '接口地址解析方式',
    `auth_method` varchar(255) DEFAULT NULL COMMENT '认证方式',
    `body_param` varchar(255) DEFAULT NULL COMMENT 'body参数',
    `response_type` varchar(255) DEFAULT NULL COMMENT '返回值类型',
    `is_auth` varchar(255) DEFAULT NULL COMMENT '是否需要授权认证',
    `tenant_id` bigint DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id` bigint DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id` bigint DEFAULT NULL COMMENT '租户组织ID',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id` bigint DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id` bigint DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id` bigint DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB COMMENT='接口定义表';