/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.platform.service;

import com.elitesland.cbpl.infinity.server.platform.repo.InfinityPlatformRepo;
import com.elitesland.cbpl.infinity.server.platform.repo.InfinityPlatformRepoProc;
import com.elitesland.cbpl.infinity.server.platform.service.InfinityPlatformService;
import com.elitesland.cbpl.infinity.server.platform.vo.param.InfinityPlatformParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.InfinityPlatformRespVO;
import com.elitesland.cbpl.infinity.server.router.convert.RouterConvert;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InfinityPlatformServiceImpl
implements InfinityPlatformService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityPlatformServiceImpl.class);
    private final InfinityPlatformRepo platformRepo;
    private final InfinityPlatformRepoProc platformRepoProc;

    @Override
    public List<InfinityPlatformRespVO> queryAuths(InfinityPlatformParamVO param) {
        List<InfinityPlatformRespVO> auths = this.platformRepoProc.queryAuth(param);
        if (auths.isEmpty()) {
            throw PhoenixException.unchecked((String)("[INFINITY-PLATFORM] auth account not exist: " + param));
        }
        return auths;
    }

    @Override
    public InfinityPlatformRespVO queryOneAuth(InfinityRouterParamVO param) {
        List<InfinityPlatformRespVO> auths = this.queryAuths(RouterConvert.INSTANCE.httpToAuthParam(param));
        if (auths.size() > 1) {
            throw PhoenixException.unchecked((String)("[INFINITY-PLATFORM] auth account not unique: " + param.toString()));
        }
        return auths.get(0);
    }

    public InfinityPlatformServiceImpl(InfinityPlatformRepo platformRepo, InfinityPlatformRepoProc platformRepoProc) {
        this.platformRepo = platformRepo;
        this.platformRepoProc = platformRepoProc;
    }
}

