/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.router.service;

import com.elitesland.cbpl.infinity.server.router.repo.InfinityRouterRepoProc;
import com.elitesland.cbpl.infinity.server.router.service.InfinityRouterService;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.server.router.vo.resp.InfinityRouterRespVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InfinityRouterServiceImpl
implements InfinityRouterService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityRouterServiceImpl.class);
    private final InfinityRouterRepoProc routerRepoProc;

    @Override
    public List<InfinityRouterRespVO> queryApis(InfinityRouterParamVO param) {
        List<InfinityRouterRespVO> apis = this.routerRepoProc.queryApis(param);
        if (apis.isEmpty()) {
            throw PhoenixException.unchecked((String)("[INFINITY-ROUTER] http api not exist: " + param));
        }
        return apis;
    }

    @Override
    public InfinityRouterRespVO queryOneApi(InfinityRouterParamVO param) {
        List<InfinityRouterRespVO> apis = this.queryApis(param);
        if (apis.size() > 1) {
            throw PhoenixException.unchecked((String)("[INFINITY-ROUTER] http api not unique: " + param.toString()));
        }
        return apis.get(0);
    }

    public InfinityRouterServiceImpl(InfinityRouterRepoProc routerRepoProc) {
        this.routerRepoProc = routerRepoProc;
    }
}

