package com.elitesland.cbpl.infinity.bpmn.component;

import com.elitesland.cbpl.bpmn.domain.constant.BpmnConstant;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeIteratorComponent;
import lombok.extern.slf4j.Slf4j;

import java.util.Iterator;

/**
 * 迭代器包装节点
 *
 * @author eric.hao
 * @since 2024/05/21
 */
@Slf4j
@LiteflowComponent(BpmnConstant.BPMN_NODE_ITERATOR)
public class InfinityIteratorComponent extends NodeIteratorComponent {

    @SuppressWarnings("unchecked")
    @Override
    public Iterator<?> processIterator() throws Exception {
        var ctx = this.getContextBean(StandardContext.class);
        var result = BeanUtils.toMapList(BeanUtils.toJsonStr(ctx.getPrevParam()));
        // 1. 下一节点，可以直接读取该数据；作为入参；
        ctx.setResponse(result);
        LogUtil.info("[BPMN][ITERATOR] response: {}", result);
        // 2. 也可以配合`InfinityCurrLoopComponent.class`节点，逐行遍历读取数据
        return result.iterator();
    }
}
