package com.elitesland.cbpl.infinity.server.api.vo.param;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.server.api.domain.FormColumnDefinition;
import com.elitesland.cbpl.infinity.server.api.domain.JsonColumnDefinition;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 接口定义
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@ApiModel("接口定义")
public class ApiSaveParamVO {

    @ApiModelProperty(value = "唯一标识")
    private Long id;

    @ApiModelProperty(value = "平台编码")
    @NotBlank(message = "平台编码必填")
    private String platformCode;

    @ApiModelProperty(value = "分组id")
    private Long folderId;

    @ApiModelProperty(value = "服务url前缀")
    private String serverUrl;

    @ApiModelProperty(value = "认证方式")
    @NotBlank(message = "认证方式必填")
    private String authMethod;

    @ApiModelProperty(value = "BasicAuth 认证账号")
    private BasicAuthAccountVO basicAuthAccount;

    @ApiModelProperty(value = "OAuth2.0 认证账号")
    private OAuth2AccountVO oauth2Account;

    @ApiModelProperty(value = "接口编码")
    @NotBlank(message = "接口编码必填")
    private String apiCode;

    @ApiModelProperty(value = "接口名称")
    @NotBlank(message = "接口名称必填")
    private String apiName;

    @ApiModelProperty(value = "接口地址")
    @NotBlank(message = "接口地址必填")
    private String apiUrl;

    @ApiModelProperty(value = "请求方式")
    @NotNull(message = "请求方式必填")
    @Enumerated(EnumType.STRING)
    private HttpMethod requestMethod;

    @ApiModelProperty(value = "接口状态")
    @NotNull(message = "接口状态必填")
    private Integer apiStatus;

    @ApiModelProperty(value = "header参数")
    private List<FormColumnDefinition> headerParam;

    @ApiModelProperty(value = "查询参数")
    private List<FormColumnDefinition> queryParam;

    @ApiModelProperty(value = "路径参数")
    private List<FormColumnDefinition> pathParam;

    @ApiModelProperty(value = "媒体类型")
    private String mediaType;

    /**
     * <li>mediaType.in(array, object) ==> JsonColumnDefinition</li>
     * <li>mediaType.nin(array, object) ==> List.of(FormColumnDefinition)</li>
     */
    @ApiModelProperty(value = "body参数")
    private Object bodyParam;

    @ApiModelProperty(value = "响应报文结构")
    private JsonColumnDefinition response;

    @ApiModelProperty(value = "文档说明(支持markdown)")
    private String description;

    @ApiModelProperty(value = "备注")
    private String remark;

    public boolean isNew() {
        return ObjectUtil.isNull(id);
    }
}
