package com.elitesland.cbpl.infinity.server.folder.convert;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiRespVO;
import com.elitesland.cbpl.infinity.server.folder.entity.InfinityFolderDO;
import com.elitesland.cbpl.infinity.server.folder.vo.param.FolderSaveParamVO;
import com.elitesland.cbpl.infinity.server.folder.vo.resp.FolderRespVO;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

import java.util.List;

import static com.elitesland.cbpl.common.constant.AuthMethod.AUTH_METHOD_BASIC_AUTH;
import static com.elitesland.cbpl.common.constant.AuthMethod.AUTH_METHOD_OAUTH_V2;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Mapper(config = BaseMapperConfig.class)
public interface InfinityFolderConvert {

    InfinityFolderConvert INSTANCE = Mappers.getMapper(InfinityFolderConvert.class);

    /**
     * SaveParam => DO
     */
    @Mapping(target = "authAccount", expression = "java(authAccountToStr(saveParam))")
    InfinityFolderDO saveParamToDO(FolderSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    @Mapping(target = "authAccount", expression = "java(authAccountToStr(saveParam))")
    void saveParamMergeToDO(FolderSaveParamVO saveParam, @MappingTarget InfinityFolderDO infinityFolderDO);

    /**
     * FolderDO => ApiVO
     */
    List<InfinityApiRespVO> toApiFolder(List<InfinityFolderDO> folderRespVOS);

    /**
     * FolderDO => ApiVO
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "platformCode", ignore = true)
    @Mapping(target = "remark", ignore = true)
    @Mapping(target = "folderId", source = "id")
    @Mapping(target = "basicAuthAccount", expression = "java(toBasicAuthAccount(folderRespVOS.getAuthAccount()))")
    @Mapping(target = "oauth2Account", expression = "java(toOAuthAccount(folderRespVOS.getAuthAccount()))")
    InfinityApiRespVO toApiFolder(InfinityFolderDO folderRespVOS);

    @Named("authAccountToStr")
    default String authAccountToStr(FolderSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toJsonStr(saveParam.getBasicAuthAccount());
        }
        if (saveParam.getAuthMethod().equals(AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toJsonStr(saveParam.getOauth2Account());
        }
        return "";
    }

    @Named("toBasicAuthAccount")
    default BasicAuthAccountVO toBasicAuthAccount(String authAccount) {
        if (StrUtil.isBlank(authAccount)) {
            return null;
        }
        return BeanUtils.toBean(authAccount, BasicAuthAccountVO.class);
    }

    @Named("toOAuthAccount")
    default OAuth2AccountVO toOAuthAccount(String authAccount) {
        if (StrUtil.isBlank(authAccount)) {
            return null;
        }
        return BeanUtils.toBean(authAccount, OAuth2AccountVO.class);
    }
}
