/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.bpmn.component;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.bpmn.domain.context.StandardContext;
import com.elitesland.cbpl.infinity.web.http.domain.InfinityResult;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.http.service.InfinityRestClient;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LiteflowComponent(value="__infinity")
public class InfinityStandardComponent
extends NodeComponent {
    private static final Logger logger = LoggerFactory.getLogger(InfinityStandardComponent.class);
    private static final String INFINITY_API_CODE = "IAC";
    @Resource
    private InfinityRestClient restClient;

    public void process() throws Exception {
        Map nodeParam = (Map)this.getCmpData(Map.class);
        StandardContext standardContext = (StandardContext)this.getContextBean(StandardContext.class);
        HttpParam httpParam = (HttpParam)BeanUtils.toBean((Object)standardContext.getPrevParam(), HttpParam.class);
        String apiCode = nodeParam.getOrDefault(INFINITY_API_CODE, "").toString();
        if (StrUtil.isBlank((CharSequence)apiCode)) {
            LogUtil.error((String)"[BPMN][INFINITY]: empty apiCode.");
            return;
        }
        LogUtil.info((String)("[BPMN][INFINITY] apiCode: " + apiCode));
        InfinityResult<Object> resp = ObjectUtil.isNull((Object)httpParam) ? this.restClient.exchange(apiCode, Object.class) : this.restClient.exchange(apiCode, Object.class, builder -> {
            if (MapUtil.isNotEmpty(httpParam.getHeaderParam())) {
                builder.headerParam(httpParam.getHeaderParam());
            }
            if (MapUtil.isNotEmpty(httpParam.getQueryParam())) {
                builder.queryParam(httpParam.getQueryParam());
            }
            if (MapUtil.isNotEmpty(httpParam.getPathParam())) {
                builder.pathParam(httpParam.getPathParam());
            }
            if (ObjectUtil.isNotNull((Object)httpParam.getBodyParam())) {
                builder.bodyParam(httpParam.getBodyParam());
            }
            return builder.build();
        });
        Object response = resp.toEntity();
        standardContext.setResponse(response);
        LogUtil.info((String)"[BPMN][INFINITY] response: ", (Object)response);
    }
}

