/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.account.controller;

import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountPagingParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountQueryParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.param.InfinityAccountSaveParamVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountDetailVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountPagingVO;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bf9\u5916\u63d0\u4f9b\u63a5\u53e3\u7684\u8ba4\u8bc1\u8d26\u53f7"})
@RestController
@RequestMapping(value={"/infinity/server/account"})
public class InfinityAccountController {
    private static final Logger logger = LoggerFactory.getLogger(InfinityAccountController.class);
    private final InfinityAccountService infinityAccountService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public HttpResult<PagingVO<InfinityAccountPagingVO>> list(@RequestBody InfinityAccountPagingParamVO query) {
        logger.info("[InfinityAccount] query paging param = {}", (Object)query);
        return HttpResult.ok(this.infinityAccountService.infinityAccountPageBy(query));
    }

    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public HttpResult<List<InfinityAccountRespVO>> query(@RequestBody InfinityAccountQueryParamVO query) {
        logger.info("[InfinityAccount] query list param = {}", (Object)query);
        return HttpResult.ok(this.infinityAccountService.infinityAccountByParam(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<InfinityAccountDetailVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[InfinityAccount] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.infinityAccountService.infinityAccountById(id));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/create"})
    public HttpResult<Long> create(@RequestBody InfinityAccountSaveParamVO saveParam) {
        logger.info("[InfinityAccount] create one record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.infinityAccountService.create(saveParam));
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PutMapping(value={"/update"})
    public HttpResult<Long> update(@RequestBody InfinityAccountSaveParamVO saveParam) {
        logger.info("[InfinityAccount] update one record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.infinityAccountService.update(saveParam));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody InfinityAccountSaveParamVO saveParam) {
        logger.info("[InfinityAccount] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.infinityAccountService.save(saveParam));
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/{id}/v"})
    public HttpResult<Void> active(@PathVariable(value="id") Long id) {
        logger.info("[InfinityAccount] active by id = {}", (Object)id);
        this.infinityAccountService.updateStatus(id, "1");
        return HttpResult.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/{id}/x"})
    public HttpResult<Void> inactive(@PathVariable(value="id") Long id) {
        logger.info("[InfinityAccount] inactive by id = {}", (Object)id);
        this.infinityAccountService.updateStatus(id, "0");
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public HttpResult<Void> delete(@RequestBody List<Long> ids) {
        logger.info("[InfinityAccount] batch physical delete by ids = {}", ids);
        this.infinityAccountService.delete(ids);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    @PutMapping(value={"/delete"})
    public HttpResult<Void> updateDeleteFlag(@RequestBody List<Long> ids) {
        logger.info("[InfinityAccount] batch logic delete by ids = {}", ids);
        this.infinityAccountService.updateDeleteFlag(ids);
        return HttpResult.ok();
    }

    public InfinityAccountController(InfinityAccountService infinityAccountService) {
        this.infinityAccountService = infinityAccountService;
    }
}

