/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.folder.convert;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.server.api.vo.resp.InfinityApiRespVO;
import com.elitesland.cbpl.infinity.server.folder.entity.InfinityFolderDO;
import com.elitesland.cbpl.infinity.server.folder.vo.param.FolderSaveParamVO;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper(config=BaseMapperConfig.class)
public interface InfinityFolderConvert {
    public static final InfinityFolderConvert INSTANCE = (InfinityFolderConvert)Mappers.getMapper(InfinityFolderConvert.class);

    @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")
    public InfinityFolderDO saveParamToDO(FolderSaveParamVO var1);

    @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")
    public void saveParamMergeToDO(FolderSaveParamVO var1, @MappingTarget InfinityFolderDO var2);

    public List<InfinityApiRespVO> toApiFolder(List<InfinityFolderDO> var1);

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="platformCode", ignore=true), @Mapping(target="remark", ignore=true), @Mapping(target="folderId", source="id"), @Mapping(target="basicAuthAccount", expression="java(toBasicAuthAccount(folderRespVOS.getAuthAccount()))"), @Mapping(target="oauth2Account", expression="java(toOAuthAccount(folderRespVOS.getAuthAccount()))")})
    public InfinityApiRespVO toApiFolder(InfinityFolderDO var1);

    @Named(value="authAccountToStr")
    default public String authAccountToStr(FolderSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toJsonStr((Object)saveParam.getBasicAuthAccount());
        }
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toJsonStr((Object)saveParam.getOauth2Account());
        }
        return "";
    }

    @Named(value="toBasicAuthAccount")
    default public BasicAuthAccountVO toBasicAuthAccount(String authAccount) {
        if (StrUtil.isBlank((CharSequence)authAccount)) {
            return null;
        }
        return (BasicAuthAccountVO)BeanUtils.toBean((String)authAccount, BasicAuthAccountVO.class);
    }

    @Named(value="toOAuthAccount")
    default public OAuth2AccountVO toOAuthAccount(String authAccount) {
        if (StrUtil.isBlank((CharSequence)authAccount)) {
            return null;
        }
        return (OAuth2AccountVO)BeanUtils.toBean((String)authAccount, OAuth2AccountVO.class);
    }
}

