/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.server.platform.convert;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.common.constant.AuthMethod;
import com.elitesland.cbpl.infinity.server.platform.entity.InfinityPlatformDO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformSaveParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformPagingVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformRespVO;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper(config=BaseMapperConfig.class)
public interface InfinityPlatformConvert {
    public static final InfinityPlatformConvert INSTANCE = (InfinityPlatformConvert)Mappers.getMapper(InfinityPlatformConvert.class);

    public List<PlatformPagingVO> toPageVO(List<InfinityPlatformDO> var1);

    @Mappings(value={@Mapping(target="basicAuthAccount", expression="java(toBasicAuthAccount(platformDO.getAuthAccount()))"), @Mapping(target="oauth2Account", expression="java(toOAuthAccount(platformDO.getAuthAccount()))")})
    public PlatformPagingVO toPageVO(InfinityPlatformDO var1);

    public List<PlatformRespVO> doToVO(List<InfinityPlatformDO> var1);

    @Mappings(value={@Mapping(target="basicAuthAccount", expression="java(toBasicAuthAccount(platformDO.getAuthAccount()))"), @Mapping(target="oauth2Account", expression="java(toOAuthAccount(platformDO.getAuthAccount()))")})
    public PlatformRespVO doToVO(InfinityPlatformDO var1);

    @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")
    public InfinityPlatformDO saveParamToDO(PlatformSaveParamVO var1);

    @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")
    public void saveParamMergeToDO(PlatformSaveParamVO var1, @MappingTarget InfinityPlatformDO var2);

    @Named(value="authAccountToStr")
    default public String authAccountToStr(PlatformSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toJsonStr((Object)saveParam.getBasicAuthAccount());
        }
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toJsonStr((Object)saveParam.getOauth2Account());
        }
        return "";
    }

    @Named(value="toBasicAuthAccount")
    default public BasicAuthAccountVO toBasicAuthAccount(String authAccount) {
        if (StrUtil.isBlank((CharSequence)authAccount)) {
            return null;
        }
        return (BasicAuthAccountVO)BeanUtils.toBean((String)authAccount, BasicAuthAccountVO.class);
    }

    @Named(value="toOAuthAccount")
    default public OAuth2AccountVO toOAuthAccount(String authAccount) {
        if (StrUtil.isBlank((CharSequence)authAccount)) {
            return null;
        }
        return (OAuth2AccountVO)BeanUtils.toBean((String)authAccount, OAuth2AccountVO.class);
    }
}

