/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.http.domain;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.logging.infinity.util.InfinityLogUtil;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StopWatch;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class InfinityResult<T> {
    private static final Logger logger = LoggerFactory.getLogger(InfinityResult.class);
    @ApiModelProperty(value="\u54cd\u5e94\u503c\u7684\u5b9e\u4f53\u7c7b\u578b")
    private Class<T> responseType;
    private HttpParam param;
    private WebClient.RequestBodySpec uri;

    public List<T> toList() {
        return (List)this.wrapper(response -> response.bodyToFlux(this.responseType).collectList());
    }

    public T toEntity() {
        return (T)this.wrapper(response -> response.bodyToMono(this.responseType));
    }

    private <R> R wrapper(Function<ClientResponse, Mono<R>> fn) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        AtomicReference<String> errorMessage = new AtomicReference<String>("");
        Object result = this.uri.exchangeToMono(response -> {
            if (response.statusCode() == HttpStatus.OK) {
                return (Mono)fn.apply((ClientResponse)response);
            }
            return response.createException().flatMap(Mono::error);
        }).onErrorResume(e -> {
            errorMessage.set(ExceptionUtils.formatException((Throwable)e, (int)2000));
            logger.error("[INFINITY] RestAPI Invoke Error: ", e);
            return Mono.empty();
        }).block();
        stopWatch.stop();
        InfinityLogUtil.record((Object)this.param, (Object)result, (String)errorMessage.get(), (double)stopWatch.getTotalTimeSeconds());
        if (StrUtil.isNotBlank((CharSequence)errorMessage.get())) {
            throw new RuntimeException(errorMessage.get());
        }
        return (R)result;
    }

    private InfinityResult(Class<T> responseType, HttpParam param, WebClient.RequestBodySpec uri) {
        this.responseType = responseType;
        this.param = param;
        this.uri = uri;
    }

    public static <T> InfinityResult<T> of(Class<T> responseType, HttpParam param, WebClient.RequestBodySpec uri) {
        return new InfinityResult<T>(responseType, param, uri);
    }
}

