/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.security.service.oauth2;

import com.elitesland.cbpl.infinity.web.security.service.oauth2.AccessToken;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

public class OAuth2Client {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2Client.class);
    private final WebClient webClient;

    public String getAccessToken(String url, String clientId, String clientSecret) {
        AccessToken token = this.authentication(url, clientId, clientSecret, AccessToken.class);
        String accessToken = token.getAccessToken();
        LogUtil.info((String)("[BPMN][INFINITY] OAuth2 AccessToken: " + accessToken));
        return accessToken;
    }

    public String authentication(String url, String clientId, String clientSecret) {
        String accessToken = this.authentication(url, clientId, clientSecret, String.class);
        LogUtil.info((String)("[BPMN][INFINITY] OAuth2 AccessToken: " + accessToken));
        return accessToken;
    }

    public <T> T authentication(String url, String clientId, String clientSecret, Class<T> clazz) {
        LogUtil.info((String)("[BPMN][INFINITY] OAuth2 Url: " + url));
        LogUtil.info((String)("[BPMN][INFINITY] OAuth2 clientId: " + clientId));
        WebClient.RequestBodyUriSpec uriSpec = this.webClient.method(HttpMethod.POST);
        WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(url, new Object[0]);
        bodySpec.acceptCharset(new Charset[]{StandardCharsets.UTF_8});
        bodySpec.contentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"grant_type", (Object)"client_credentials");
        multiValueMap.add((Object)"client_id", (Object)clientId);
        multiValueMap.add((Object)"client_secret", (Object)clientSecret);
        bodySpec.body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)multiValueMap));
        return (T)bodySpec.retrieve().bodyToMono(clazz).block();
    }

    public OAuth2Client(WebClient webClient) {
        this.webClient = webClient;
    }
}

