package com.elitesland.cbpl.infinity.server.platform.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;

/**
 * 接口平台(对接系统)
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_infinity_platform")
@org.hibernate.annotations.Table(appliesTo = "sys_infinity_platform", comment = "接口平台(对接系统)")
@ApiModel("接口平台(对接系统)")
public class InfinityPlatformDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 2041487413938972831L;

    /**
     * 平台名称
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "平台名称")
    @Column(name = "platform_name", nullable = true, length = 128)
    private String platformName;

    /**
     * 平台编码
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "平台编码")
    @Column(name = "platform_code", nullable = true, length = 64)
    private String platformCode;

    /**
     * 服务url前缀
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "服务url前缀")
    @Column(name = "server_url", nullable = true, length = 255)
    private String serverUrl;

    /**
     * 认证方式
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "认证方式")
    @Column(name = "auth_method", nullable = true, length = 32)
    private String authMethod;

    /**
     * 认证账号
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "认证账号")
    @Column(name = "auth_account", nullable = true, length = 32)
    private String authAccount;

    /**
     * 文档说明(支持markdown)
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "文档说明(支持markdown)")
    @Column(name = "description", nullable = true)
    private String description;
}
