package com.elitesland.cbpl.infinity.web.security.util;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.web.security.domain.BasicAuthAccountVO;
import com.elitesland.cbpl.infinity.web.security.domain.OAuth2AccountVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;

import static com.elitesland.cbpl.common.constant.AuthMethod.AUTH_METHOD_BASIC_AUTH;
import static com.elitesland.cbpl.common.constant.AuthMethod.AUTH_METHOD_OAUTH_V2;

/**
 * 认证账号转换工具
 *
 * @author eric.hao
 * @since 2024/06/11
 */
public class AuthAccountResolve {

    public static BasicAuthAccountVO getBasicAuthAccount(String authMethod, String authAccount) {
        if (StrUtil.isBlank(authAccount)) {
            return null;
        }
        if (authMethod.equals(AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toBean(authAccount, BasicAuthAccountVO.class);
        }
        return null;
    }

    public static OAuth2AccountVO getOauth2Account(String authMethod, String authAccount) {
        if (StrUtil.isBlank(authAccount)) {
            return null;
        }
        if (authMethod.equals(AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toBean(authAccount, OAuth2AccountVO.class);
        }
        return null;
    }
}
