package com.elitesland.cbpl.infinity.server.api.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.http.HttpMethod;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 接口定义
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_infinity_api")
@org.hibernate.annotations.Table(appliesTo = "sys_infinity_api", comment = "接口定义")
@ApiModel("接口定义")
public class InfinityApiDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1407016475474729387L;

    /**
     * 平台编码
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "平台编码")
    @Column(name = "platform_code", nullable = true, length = 64)
    private String platformCode;

    /**
     * 分组id
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "分组id")
    @Column(name = "folder_id", nullable = true, length = 20)
    private Long folderId;

    /**
     * 服务url前缀
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "服务url前缀")
    @Column(name = "server_url", nullable = true, length = 255)
    private String serverUrl;

    /**
     * 认证方式
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "认证方式")
    @Column(name = "auth_method", nullable = true, length = 32)
    private String authMethod;

    /**
     * 认证账号
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "认证账号")
    @Column(name = "auth_account", nullable = true, length = 32)
    private String authAccount;

    /**
     * 接口编码
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "接口编码")
    @Column(name = "api_code", nullable = true, length = 64)
    private String apiCode;

    /**
     * 接口名称
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "接口名称")
    @Column(name = "api_name", nullable = true, length = 64)
    private String apiName;

    /**
     * 接口地址
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "接口地址")
    @Column(name = "api_url", nullable = true, length = 1000)
    private String apiUrl;

    /**
     * 请求方式
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "请求方式")
    @Column(name = "request_method", nullable = true, length = 16)
    @Enumerated(EnumType.STRING)
    private HttpMethod requestMethod;

    /**
     * 接口状态
     * nullable : false
     * default  : null
     */
    @ApiModelProperty(value = "接口状态")
    @Column(name = "api_status", nullable = true, length = 11)
    private Integer apiStatus;

    /**
     * header参数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "header参数")
    @Column(name = "header_param", nullable = true)
    private String headerParam;

    /**
     * 查询参数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "查询参数")
    @Column(name = "query_param", nullable = true)
    private String queryParam;

    /**
     * 路径参数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "路径参数")
    @Column(name = "path_param", nullable = true)
    private String pathParam;

    /**
     * 媒体类型
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "媒体类型")
    @Column(name = "media_type", nullable = true, length = 64)
    private String mediaType;

    /**
     * body参数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "body参数")
    @Column(name = "body_param", nullable = true)
    private String bodyParam;

    /**
     * 响应报文结构
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "响应报文结构")
    @Column(name = "response", nullable = true)
    private String response;

    /**
     * 文档说明(支持markdown)
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "文档说明(支持markdown)")
    @Column(name = "description", nullable = true)
    private String description;
}
