package com.elitesland.cbpl.infinity.server.api.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;

import java.time.LocalDateTime;

/**
 * 接口定义
 *
 * @author eric.hao
 * @since 2024/05/16
 */
@Data
@ApiModel("接口定义")
public class InfinityApiMergeVO {

    @ApiModelProperty(value = "唯一标识")
    private Long id;

    @ApiModelProperty(value = "平台编码")
    private String platformCode;

    @ApiModelProperty(value = "分组id")
    private Long folderId;

    // API相关
    @ApiModelProperty(value = "服务url前缀")
    private String apiServerUrl;

    @ApiModelProperty(value = "认证方式")
    private String apiAuthMethod;

    @ApiModelProperty(value = "认证账号")
    private String apiAuthAccount;

    // Folder相关
    @ApiModelProperty(value = "服务url前缀")
    private String folderServerUrl;

    @ApiModelProperty(value = "认证方式")
    private String folderAuthMethod;

    @ApiModelProperty(value = "认证账号")
    private String folderAuthAccount;

    // Platform相关
    @ApiModelProperty(value = "服务url前缀")
    private String platformServerUrl;

    @ApiModelProperty(value = "认证方式")
    private String platformAuthMethod;

    @ApiModelProperty(value = "认证账号")
    private String platformAuthAccount;

    @ApiModelProperty(value = "接口编码")
    private String apiCode;

    @ApiModelProperty(value = "接口名称")
    private String apiName;

    @ApiModelProperty(value = "接口地址")
    private String apiUrl;

    @ApiModelProperty(value = "请求方式")
    private HttpMethod requestMethod;

    @ApiModelProperty(value = "接口状态")
    private Integer apiStatus;

    @ApiModelProperty(value = "header参数")
    private String headerParam;

    @ApiModelProperty(value = "查询参数")
    private String queryParam;

    @ApiModelProperty(value = "路径参数")
    private String pathParam;

    @ApiModelProperty(value = "媒体类型")
    private String mediaType;

    @ApiModelProperty(value = "body参数")
    private String bodyParam;

    @ApiModelProperty(value = "响应报文结构")
    private String response;

    @ApiModelProperty(value = "文档说明(支持markdown)")
    private String description;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "记录创建者id")
    private Long createUserId;

    @ApiModelProperty(value = "记录创建者")
    private String creator;

    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "记录最后更新者id")
    private Long modifyUserId;

    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;
}
