package com.elitesland.cbpl.infinity.server.platform.repo;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.infinity.server.platform.entity.InfinityPlatformDO;
import com.elitesland.cbpl.infinity.server.platform.entity.QInfinityPlatformDO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformPagingParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.param.PlatformQueryParamVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformPagingVO;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.PlatformRespVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.*;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/05/16
 */
@Component
@RequiredArgsConstructor
public class InfinityPlatformRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QInfinityPlatformDO platformDO = QInfinityPlatformDO.infinityPlatformDO;

    private final QBean<PlatformPagingVO> platformPagingVO = Projections.bean(
            PlatformPagingVO.class,
            platformDO.id,
            platformDO.platformName,
            platformDO.platformCode,
            platformDO.serverUrl,
            platformDO.authMethod,
            platformDO.description,
            platformDO.remark,
            platformDO.createUserId,
            platformDO.creator,
            platformDO.createTime,
            platformDO.modifyUserId,
            platformDO.updater,
            platformDO.modifyTime
    );

    private Predicate pagingWhere(PlatformPagingParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(platformDO.deleteFlag.eq(0));
        if (StrUtil.isNotBlank(query.getPlatformCodeName())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getPlatformCodeName());
            predicates.add(platformDO.platformCode.eq(likeStr).or(platformDO.platformName.like(likeStr)));
        }
        if (StrUtil.isNotBlank(query.getServerUrl())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getServerUrl());
            predicates.add(platformDO.serverUrl.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long platformCountBy(PlatformPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(platformDO.id)
                .from(platformDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<InfinityPlatformDO> platformPageBy(PlatformPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(platformDO)
                .from(platformDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, platformDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private final QBean<PlatformRespVO> platformVO = Projections.bean(
            PlatformRespVO.class,
            platformDO.id,
            platformDO.platformName,
            platformDO.platformCode,
            platformDO.serverUrl,
            platformDO.authMethod,
            platformDO.remark
    );

    private Predicate where(PlatformQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(platformDO.deleteFlag.eq(0));
        if (StrUtil.isNotBlank(query.getPlatformCodeName())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getPlatformCodeName());
            predicates.add(platformDO.platformCode.eq(likeStr).or(platformDO.platformName.like(likeStr)));
        }
        if (StrUtil.isNotBlank(query.getServerUrl())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getServerUrl());
            predicates.add(platformDO.serverUrl.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<InfinityPlatformDO> platformByParam(PlatformQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(platformDO)
                .from(platformDO);
        // 按名称正序
        jpaQuery.orderBy(new OrderSpecifier<>(Order.ASC, platformDO.platformName));
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long delete(List<Long> ids) {
        JPADeleteClause delete = jpaQueryFactory.delete(platformDO)
                .where(platformDO.id.in(ids));
        return delete.execute();
    }
}
